/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  main.c
//  Display board for PSU350W

//  Matthias Ulmann, Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//  September 21th, 2011 - Version 1.00
//  Built with Code Composer Studio Core Edition Version: 5.1.1.00028
//
//	Device: MPS430F2252
//
//******************************************************************************


#include "main.h"



// used for delay
unsigned int i_delay=0;

// global variables for scheduler
volatile unsigned int flag_10ms=1;				// used for 10ms timing
static volatile unsigned int counter_10ms=0;	// used for 10ms timing
static volatile unsigned int flag_50ms=1;		// used for 50ms timing
static volatile unsigned int counter_50ms=0;	// used for 50ms timing
static volatile unsigned int flag_100ms=1;		// used for 100ms timing
static volatile unsigned int counter_5s=0;		// used for 5s timing
static volatile unsigned int flag_5s=0;			// used for 5s timing

// global variable to handle the menu
volatile unsigned int menu_selection=1, menu_config=0, backlight_on=1, backlight_continuous=0;

// global variables for reading and debouncing the switches
static volatile unsigned int ct0=0, ct1=0, rpt=0, i=0;		// used for debouncing
volatile unsigned int key_press=0;		// key press detect
volatile unsigned int key_rpt=0;		// key long press and repeat
volatile unsigned int key_state=0;		// debounced and inverted key state:
										// bit = 1: key pressed
volatile unsigned int rpt_active=0;
volatile unsigned int rpt_state=0;									
																			
volatile unsigned int key_mode_short=0, key_plus_short=0, key_minus_short=0, key_enable_short;
volatile unsigned int key_mode_rpt=0, key_plus_rpt=0, key_minus_rpt=0, key_enable_rpt;

// global variables to store the temperatures in degrees
volatile unsigned int temp_pfc, temp_hbridge=0, temp_chassis=0;

// global variables to store the output voltage and current
volatile unsigned int voltage_output=0, current_output=0;

// global variables to store the mains and the pfc voltage
volatile unsigned int voltage_mains=110, voltage_pfc=390;

// global variable to select the channel on ADS1015
volatile unsigned int I2C_channel=0;

// variable to control the I2C communication
volatile unsigned int I2C_flow=0;

// global variable for setting the reference voltage;
volatile signed int ref_voltage;

// global variables for setting the switching frequency
volatile unsigned int threshold0_fswitch;

// global variable to store the state (on/off/fault) of the power supply
volatile unsigned int status_supply=0;

// global variable to store the state of the backlight
volatile unsigned int status_backlight=0;



void main(void)
{
	WDTCTL = WDTPW + WDTHOLD;	// stop watchdog

	
	// Delay of 1s to be sure that the supply voltage reached 3.45V.
	// The clock frequency can only be set to 16 MHz when the supply
	// voltage is high enough.
	// The initial clock frequency is 1 MHz. The delay-routine is made
	// for 16 MHz. So at 1 MHz 1/16 of the delay is only needed.
	// 1s @ 16 MHz = 62.5ms @ 1 MHz
	i_delay = 0;
	while(i_delay < 5000)
	{
		delay_us(12);				// results in 2ms @ 1 MHz
		i_delay++;
	}
	

	init_general();					// general initializations (clock module)
	init_enable();					// initialization of the enable output
	init_backlight();				// initialization of LCD backlight
	init_led();						// initialization of LED
	init_switches();				// initialization of switches
	flash_restore_configuration();	// restore the saved presets from flash
	lcd_init(LCD_DISP_ON);			// initialization of the LCD
	init_adc();						// init AD converter and analog inputs
	init_i2c();						// initialization of the I2C interface
	init_timerB();					// initialization of Timer_B, main/bias sync
	init_timerA();					// initialization of Timer_A, reference voltage
	
	_EINT();                  		  // enable interrupts (general)
	
	
	// A delay of at least 1s is needed to ensure a proper startup of the
	// PFC stage. During this time a message is shown.
	BLIGHT_on;
	lcd_gotoxy(5,0); lcd_puts("TEXAS");
	lcd_gotoxy(2,1); lcd_puts("INSTRUMENTS");
	

	i_delay = 0;
	while(i_delay<300)		// 1.5s delay
	{
		delay_ms(5);
		i_delay++;
	}

	lcd_clrscr();
	lcd_gotoxy(4,0); lcd_puts("PSU350W");
	lcd_gotoxy(2,1); lcd_puts("12..14V/25A");
	

	i_delay = 0;
	while(i_delay<150)		// 1.5s delay
	{
		delay_ms(10);
		i_delay++;
	}

	lcd_clrscr();
  	
  	
  	// enable synchronization and reference voltage signal
  	sync_main_on;
	sync_aux_on;
	ref_voltage_on;
	
	
  	
  	// enable AD conversion
   	set_bit(ADC10CTL0, ENC);
   	// start AD conversion     
   	set_bit(ADC10CTL0, ADC10SC);



   	for (;;)
	{

		if(flag_5s)	// used to switch the backlight off after 5s
		{
			flag_5s = 0;			// reset flag
			
			if( (backlight_on && !backlight_continuous) )
			{
				backlight_on = 0;	// reset flag
				BLIGHT_off;			// switch backlight off
			}
		}
		
		
		
		// executed every 100ms
		if(flag_100ms)
		{
			flag_100ms = 0;			// reset flag
			
			counter_5s++;			// increment 1s variable
			if(counter_5s == 50)	// 1s passed
			{
				flag_5s = 1;		// set flag
				counter_5s = 0;		// reset counter
			}
			
			
			i2c_communication(); // do I2C communication
						
			
			// read and convert the analog inputs
			get_analog_inputs();
			
			
						
			// read switches
			if(get_key_short(SWITCH_MODE))
			{
				key_mode_short = 1;	
			}
			else key_mode_short = 0;
			
			if(get_key_short(SWITCH_PLUS))
			{
				key_plus_short = 1;
			}
			else key_plus_short = 0;
			
			if(get_key_short(SWITCH_MINUS))
			{
				key_minus_short = 1;				
				
			}
			else key_minus_short = 0;
			
			if(get_key_short(SWITCH_ENABLE))
			{	
				// Enable/disable power supply when ENABLE is pressed.
				// If a fault is present, don't enable supply.
				// status_supply:	0: off, 1: on, >10: fault
				if(status_supply == 1) 
				{
					POWER_off;
					status_supply = 0;
					
					counter_5s = 0;		// reset counter
					
					BLIGHT_on;			// switch backlight on
					backlight_on = 1;	// switch backlight on
				}
						
				else if(status_supply == 0)
				{
					POWER_on;
					status_supply = 1;
					
					counter_5s = 0;		// reset counter
					
					BLIGHT_on;			// switch backlight on
					backlight_on = 1;	// switch backlight on
				}
				
				// if a fault is present and ENABLE is pressed, the fault is
				// cleared but the supply is not enabled
				else if(status_supply > 10)
				{
					POWER_off;
					status_supply = 0;
					LED_off;
					
					counter_5s = 0;		// reset counter
					
					BLIGHT_on;			// switch backlight on
					backlight_on = 1;	// switch backlight on
				}
				
				key_enable_short = 1;
			}
			else key_enable_short = 0;

			if(get_key_rpt(SWITCH_MODE)) key_mode_rpt = 1;
			else key_mode_rpt = 0;
			
			if(get_key_rpt(SWITCH_PLUS)) key_plus_rpt = 1;
			else key_plus_rpt = 0;
			
			if(get_key_rpt(SWITCH_MINUS)) key_minus_rpt = 1;
			else key_minus_rpt = 0;
			
			
			
			// If the menu is not in configuration mode and the PLUS switch is pressed long,
			// the backlight keeps on all time until the PLUS switch is pressed long again.
			if( key_plus_rpt && key_minus_rpt && !menu_config )
			{
				if(backlight_continuous)	// switch continuous backlight off
				{
					backlight_continuous = 0;
					backlight_on = 0;
					BLIGHT_off;
				}
				else	// switch continuous backligh on
				{
					backlight_continuous = 1;
					backlight_on = 1;
					BLIGHT_on;
					
					// switch backlight on and off to show change
					i_delay = 0;
					while(i_delay<100)		// 0.1s delay
					{
						delay_us(1000);
						i_delay++;
					}
					
					BLIGHT_off;
					
					i_delay = 0;
					while(i_delay<100)		// 0.1s delay
					{
						delay_us(1000);
						i_delay++;
					}
					
					BLIGHT_on;
				}
			}
			
			
					
			// If any switch is pressed and the backlight is off, switch on the backlight
			// and don't consider the normal function of this switch (besides ENABLE).
			if( (!backlight_on && key_mode_short) || (!backlight_on && key_plus_short) ||
				 (!backlight_on && key_minus_short) )
			{
				BLIGHT_on;			// switch backlight on
				backlight_on = 1;	// set flag
				counter_5s = 0;		// reset counter
				
				// ignore normal function of switches
				key_mode_short = 0; key_plus_short = 0; key_minus_short = 0;
			}
			
			
			
			// If a switch is pressed during the backlight is on, the normal function
			// of the switch is used and the backlight keeps on for another 5s.
			if( (backlight_on && key_mode_short) || (backlight_on && key_plus_short) ||
				(backlight_on && key_minus_short) || (backlight_on && key_enable_short) )
			{
				backlight_on = 1;	// set flag
				counter_5s = 0;		// reset counter
			}
			
			
			
			// If MODE is pressed long, the configuration menu is enabled/disabled.
			// Configuration is only possible in menu 1 and 3.
			// During configuration the backlight remains always on
			if( (key_mode_rpt && (menu_selection == 1))
			    || (key_mode_rpt && (menu_selection == 3)) )
			{	
				if(menu_config == 1)			// disable configuration mode
				{
					menu_config = 0;
					flash_save_configuration();	// save configuration to flash
					
					backlight_on = 1;	// set flag
					
					counter_5s = 0;		// reset counter
					
					// restore state of backlight (continuous on or not)
					backlight_continuous = status_backlight;
				}
				else							// enable configuration mode
				{
					menu_config = 1;			// set flag
					
					// save state of backlight (continuous on or not)
					status_backlight = backlight_continuous;
					
					counter_5s = 0;		// reset counter
					
					// switch continuous backlight on
					backlight_continuous = 1;
					backlight_on =1;
				}
				
				key_mode_short = 0;			// reset switch
			}
			
			
			
			// change information on display when not in configuration mode
			if(key_plus_short && !menu_config)
			{
				menu_selection++;
				if(menu_selection > 5) menu_selection = 1;	// go back to beginning
				lcd_clrscr();			// clear LCD
			}
			if(key_minus_short && !menu_config)
			{
				menu_selection--;
				if(menu_selection < 1) menu_selection = 5;	// go back to end
				lcd_clrscr();			// clear LCD
			}
			
			// check if all values are within range
			// if a fault is present, switch the power supply off
			if( !check_status() )
			{
				POWER_off;
			}
			
			show_info(menu_selection);		// show menu
			
		}	// flag_100ms
		
		
		
		// executed every 50ms
		if(flag_50ms)
		{
			flag_50ms = 0;	// reset flat
			
		}	// flag_50ms
		
		
		
		// executed every 10ms, used for reading and debouncing the switches		
		if(flag_10ms)
		{
			flag_10ms = 0;			// reset flag
			counter_10ms++;			// increment 10ms variable
			counter_50ms++;			// increment 50ms variable
			

			if(counter_50ms == 5)	// 50ms passed
			{
				flag_50ms = 1;		// set flag
				counter_50ms = 0;	// reset counter
			}
			
			if(counter_10ms == 10)	// 100ms passed
			{
				flag_100ms = 1;		// set flag
				counter_10ms = 0;	// reset counter
			}
			
						
			
			i = key_state ^ SWITCH_PIN;			// key changed?
			
			i = i & BIT_MASK;					// throw away other bits
			key_state = key_state & BIT_MASK;	// throw away other bits
			
			ct0 = ~( ct0 & i );				// reset or count ct0
			ct0 = ct0 & BIT_MASK;			// throw away other bits
			ct1 = ct0 ^ (ct1 & i);			// reset or count ct1
			ct1 = ct1 & BIT_MASK;			// throw away other bits
			i &= ct0 & ct1;					// count until roll over ?
			key_state ^= i;					// then toggle debounced state
			key_press |= key_state & i;		// 1->0: key press detect
			
			if( (key_state != BIT_MASK)	&& !(rpt_active))	// check repeat function
			{
				rpt_state = ~key_state;						// save key status
				rpt_state = rpt_state & BIT_MASK;			// throw away other bits
				rpt = REPEAT_START;							// start delay
				rpt_active = 1;
			}
			
			if(rpt_active) rpt--;
			
			if( (rpt == 0) && rpt_active)
			{
				key_rpt = rpt_state & (~key_state);			// check if the key is still pressed
				key_rpt = key_rpt & BIT_MASK;				// throw away other bits
				rpt_active = 0;								// reset flag
			}
			
		}	// flag_10ms
			
	}	// for
	
}	// main
